/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.actions.recipes;

import com.blamejared.crafttweaker.api.exceptions.ScriptException;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.logger.ILogger;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRecipeBase;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipe;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;

public class ActionRemoveRecipeByOutputInput
extends ActionRemoveRecipe {
    private final IIngredient output;
    private final IIngredient input;

    public ActionRemoveRecipeByOutputInput(IRecipeManager manager, IIngredient output, IIngredient input) {
        super(manager, (IRecipe<?> recipe) -> {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (output.matches(new MCItemStackMutable(recipeOutput))) {
                for (IItemStack item : input.getItems()) {
                    if (!((Ingredient)recipe.func_192400_c().get(0)).test(item.getInternal())) continue;
                    return true;
                }
            }
            return false;
        }, (ActionRecipeBase action) -> "Removing \"" + action.getRecipeTypeName() + "\" recipes that output: " + output + "\" from an input of: " + input);
        this.output = output;
        this.input = input;
    }

    public ActionRemoveRecipeByOutputInput(IRecipeManager manager, IItemStack output, IIngredient input) {
        this(manager, (IIngredient)output, input);
    }

    @Override
    public boolean validate(ILogger logger) {
        if (this.output == null) {
            logger.throwingWarn("output cannot be null!", new ScriptException("output IItemStack cannot be null!"));
            return false;
        }
        if (this.input == null) {
            logger.throwingWarn("input cannot be null!", new ScriptException("input IIngredient cannot be null!"));
            return false;
        }
        return true;
    }
}

